<?php
require_once 'config.php';

$success = false;
$error = '';

$token = $_GET['token'] ?? '';

if (empty($token)) {
    $error = "Invalid verification link.";
} else {
    try {
        $pdo = getDBConnection();
        
        // 1. FIX: Use the correct function 'validateVerificationToken'
        $token_data = validateVerificationToken($token, 'email_verification');
        
        if (!$token_data) {
            $error = "Invalid or expired verification link. Please request a new one.";
        } else {
            // 2. FIX: 'validateVerificationToken' already marks the token as used.
            //    We just need to update the user's status.
            
            // 3. FIX: Use the correct function 'verifyUserEmail' from config.php
            $verification_success = verifyUserEmail($token_data['user_id']);
            
            if ($verification_success) {
                $success = true;
                $user_email = $token_data['email']; // Get email from token data
            } else {
                $error = "We could not verify your account. Please try again.";
            }
        }
    } catch (PDOException $e) {
        $error = "Verification failed. Please try again.";
        error_log("Email verification error: " . $e->getMessage());
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification - Airwaves credit union</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full space-y-8">
        <div class="text-center">
            <span class="text-3xl font-black text-gray-900">AIRWAVES</span><span class="text-3xl font-black text-green-800">.</span>
        </div>

        <div class="bg-white p-8 rounded-2xl shadow-lg border border-gray-200 text-center">
            <?php if ($success): ?>
                <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-check-circle text-green-600 text-2xl"></i>
                </div>
                
                <h2 class="text-2xl font-bold text-gray-900 mb-4">Email Verified!</h2>
                
                <p class="text-gray-600 mb-6">
                    Your email <strong class="text-green-800"><?php echo htmlspecialchars($user_email); ?></strong> has been successfully verified.
                </p>
                
                <p class="text-gray-600 mb-6">
                    You can now access all features of your Airwaves Credits account.
                </p>
                
                <a href="login.php" 
                   class="w-full inline-flex justify-center items-center px-4 py-3 border border-transparent text-sm font-medium rounded-lg text-white bg-green-800 hover:bg-green-700 transition-colors duration-300">
                    <i class="fas fa-sign-in-alt mr-2"></i>
                    Continue to Login
                </a>
                
            <?php else: ?>
                <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-exclamation-circle text-red-600 text-2xl"></i>
                </div>
                
                <h2 class="text-2xl font-bold text-gray-900 mb-4">Verification Failed</h2>
                
                <p class="text-gray-600 mb-6">
                    <?php echo htmlspecialchars($error); ?>
                </p>
                
                <div class="space-y-4">
                    <a href="resend-verification.php" 
                       class="w-full inline-flex justify-center items-center px-4 py-3 border border-transparent text-sm font-medium rounded-lg text-white bg-green-800 hover:bg-green-700 transition-colors duration-300">
                        <i class="fas fa-redo mr-2"></i>
                        Request New Verification Link
                    </a>
                    
                    <a href="login.php" 
                       class="w-full inline-flex justify-center items-center px-4 py-3 border border-gray-300 text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 transition-colors duration-300">
                        <i class="fas fa-sign-in-alt mr-2"></i>
                        Return to Login
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>