<?php
// This file assumes it is included from dashboard.php
// and has access to $user and $transactions variables
?>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">

    <!-- Left Column: Balance and Actions -->
    <div class="lg:col-span-2 space-y-6">

        <!-- Account Balance Card -->
        <div class="bg-gradient-to-br from-gray-900 to-green-800 text-white p-8 rounded-2xl shadow-2xl">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-sm text-green-200 font-medium uppercase tracking-wider">Available Balance</p>
                    <p class="text-4xl font-extrabold mt-2">$<?php echo number_format($user['balance'] ?? 0, 2); ?></p>
                </div>
                <i class="fas fa-wallet text-5xl text-green-600 opacity-50"></i>
            </div>
            <div class="mt-8">
                <p class="text-sm text-gray-300 font-medium uppercase tracking-wider">Account Number</p>
                <p class="text-xl font-mono tracking-wider mt-1"><?php echo htmlspecialchars($user['account_number'] ?? 'N/A'); ?></p>
            </div>
        </div>

        <!-- Quick Actions -->
        <div>
            <h2 class="text-xl font-semibold text-gray-800 mb-4">Quick Actions</h2>
            <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                <a href="#" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow text-center">
                    <i class="fas fa-paper-plane text-3xl text-green-700"></i>
                    <p class="mt-3 font-semibold text-gray-700">Send Money</p>
                </a>
                <a href="#" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow text-center">
                    <i class="fas fa-hand-holding-usd text-3xl text-green-700"></i>
                    <p class="mt-3 font-semibold text-gray-700">Request</p>
                </a>
                <a href="#" class="bg-white p-6 rounded-xl shadow-lg hover:shadow-xl transition-shadow text-center">
                    <i class="fas fa-piggy-bank text-3xl text-green-700"></i>
                    <p class="mt-3 font-semibold text-gray-700">Deposit</p>
                </a>
            </div>
        </div>
    </div>

    <!-- Right Column: My Info -->
    <div class="bg-white p-6 rounded-2xl shadow-xl space-y-4">
        <h2 class="text-xl font-semibold text-gray-800 border-b pb-3">Account Holder</h2>
        
        <div class="flex items-center space-x-4">
            <div class="w-16 h-16 bg-green-800 rounded-full flex items-center justify-center text-white text-2xl font-bold">
                <?php echo strtoupper(substr($user['full_name'] ?? 'U', 0, 1)); ?>
            </div>
            <div>
                <p class="text-lg font-bold text-gray-900"><?php echo htmlspecialchars($user['full_name'] ?? 'User'); ?></p>
                <p class="text-sm text-gray-500"><?php echo htmlspecialchars($user['email'] ?? 'No email'); ?></p>
            </div>
        </div>

        <div class="space-y-2 pt-4">
            <div>
                <p class="text-xs text-gray-400 font-medium uppercase">Phone</p>
                <p class="text-gray-700 font-medium"><?php echo htmlspecialchars($user['phone'] ?? 'Not set'); ?></p>
            </div>
            <div>
                <p class="text-xs text-gray-400 font-medium uppercase">Account Type</p>
                <p class="text-gray-700 font-medium capitalize"><?php echo htmlspecialchars($user['account_type'] ?? 'N/A'); ?></p>
            </div>
            <div>
                <p class="text-xs text-gray-400 font-medium uppercase">Member Since</p>
                <p class="text-gray-700 font-medium"><?php echo date('M d, Y', strtotime($user['created_at'] ?? time())); ?></p>
            </div>
        </div>
    </div>

    <!-- Full Width: Recent Transactions -->
    <div class="lg:col-span-3 bg-white p-6 rounded-2xl shadow-xl">
        <h2 class="text-xl font-semibold text-gray-800 mb-4">Recent Transactions</h2>
        <div class="overflow-x-auto">
            <table class="w-full text-left">
                <thead class="border-b border-gray-200">
                    <tr>
                        <th class="py-3 px-2 text-sm font-medium text-gray-500 uppercase">Date</th>
                        <th class="py-3 px-2 text-sm font-medium text-gray-500 uppercase">Description</th>
                        <th class="py-3 px-2 text-sm font-medium text-gray-500 uppercase text-right">Amount</th>
                        <th class="py-3 px-2 text-sm font-medium text-gray-500 uppercase text-center">Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($transactions as $tx): ?>
                        <tr class="border-b border-gray-100">
                            <td class="py-4 px-2 text-sm text-gray-500"><?php echo $tx['date']; ?></td>
                            <td class="py-4 px-2 text-sm font-medium text-gray-800"><?php echo htmlspecialchars($tx['desc']); ?></td>
                            <td class="py-4 px-2 text-sm font-medium text-right <?php echo $tx['amount'] < 0 ? 'text-red-600' : 'text-green-600'; ?>">
                                <?php echo $tx['amount'] < 0 ? '-' : '+'; ?>$<?php echo number_format(abs($tx['amount']), 2); ?>
                            </td>
                            <td class="py-4 px-2 text-sm text-center">
                                <?php if ($tx['status'] == 'Completed'): ?>
                                    <span class="inline-flex px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">Completed</span>
                                <?php else: ?>
                                    <span class="inline-flex px-3 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">Pending</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>