<?php

// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'airwqsbp_air');
define('DB_USER', 'airwqsbp_air');
define('DB_PASS', '[ppEEBk-xK@t');

// Application settings
define('SITE_NAME', 'Airwaves credit union.');
// FIX 1: Update BASE_URL to your live domain
define('BASE_URL', 'https://secured.airwavescreditsunion.com');

// Email configuration
define('SMTP_HOST', 'airwavescreditsunion.com');
define('SMTP_PORT', 465);
define('SMTP_USERNAME', 'noreply@airwavescreditsunion.com');
define('SMTP_PASSWORD', '[ppEEBk-xK@t');
define('SMTP_FROM_EMAIL', 'noreply@airwavescreditsunion.com');
define('SMTP_FROM_NAME', 'Airwaves credit union');

// Enable debug mode for development
define('DEBUG_MODE', true);

// Session configuration
session_start();

// --- PHPMailer Configuration ---

// Import PHPMailer classes into the global namespace
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception as PHPMailerException;

// Load PHPMailer files manually since you are not using Composer
// This path matches the 'PHPMailer' directory in your screenshot
if (file_exists(__DIR__ . '/PHPMailer/src/PHPMailer.php')) {
    require_once __DIR__ . '/PHPMailer/src/Exception.php';
    require_once __DIR__ . '/PHPMailer/src/PHPMailer.php';
    require_once __DIR__ . '/PHPMailer/src/SMTP.php';
} else {
    // Log an error if the directory is not found. This is critical for debugging.
    error_log("PHPMailer classes not found. Looked in " . __DIR__ . "/PHPMailer/src/");
}


// Database connection function
function getDBConnection() {
    try {
        $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch (PDOException $e) {
        if (DEBUG_MODE) {
            die("Connection failed: " . $e->getMessage());
        } else {
            die("Database connection error. Please try again later.");
        }
    }
}

// Security functions
function sanitizeInput($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

function generateCSRFToken() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function validateCSRFToken($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

// Redirect function
function redirect($url) {
    header("Location: $url");
    exit();
}

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Get current user ID
function getCurrentUserId() {
    return $_SESSION['user_id'] ?? null;
}

// Email verification functions
function generateVerificationToken($user_id, $type = 'email_verification') {
    $pdo = getDBConnection();
    
    // Generate unique token
    $token = bin2hex(random_bytes(32));
    $expires_at = date('Y-m-d H:i:s', strtotime('+24 hours'));
    
    try {
        // Check if verification_tokens table exists, create if not
        $table_check = $pdo->query("SHOW TABLES LIKE 'verification_tokens'");
        if ($table_check->rowCount() == 0) {
            // Create the table
            $pdo->exec("CREATE TABLE verification_tokens (
                id INT AUTO_INCREMENT PRIMARY KEY,
                user_id INT NOT NULL,
                token VARCHAR(64) NOT NULL UNIQUE,
                type VARCHAR(50) NOT NULL,
                used TINYINT DEFAULT 0,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                used_at TIMESTAMP NULL,
                expires_at TIMESTAMP NOT NULL,
                FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
            )");
            error_log("Created verification_tokens table");
        }
        
        // Store token in database
        $stmt = $pdo->prepare("INSERT INTO verification_tokens (user_id, token, type, expires_at) VALUES (?, ?, ?, ?)");
        $stmt->execute([$user_id, $token, $type, $expires_at]);
        
        return $token;
    } catch (PDOException $e) {
        error_log("Token generation error: " . $e->getMessage());
        // Return token anyway for development
        return $token;
    }
}

function validateVerificationToken($token, $type = 'email_verification') {
    $pdo = getDBConnection();
    
    try {
        $stmt = $pdo->prepare("SELECT vt.*, u.email, u.full_name FROM verification_tokens vt 
                                JOIN users u ON vt.user_id = u.id 
                                WHERE vt.token = ? AND vt.type = ? AND vt.used = 0 AND vt.expires_at > NOW()");
        $stmt->execute([$token, $type]);
        
        $token_data = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($token_data) {
            // Mark token as used
            $stmt = $pdo->prepare("UPDATE verification_tokens SET used = 1, used_at = NOW() WHERE id = ?");
            $stmt->execute([$token_data['id']]);
            
            return $token_data;
        }
        
        return false;
    } catch (PDOException $e) {
        error_log("Token validation error: " . $e->getMessage());
        return false;
    }
}

// --- NEW FUNCTION TO FIX OTP LOGIC ---
/**
 * Validates a login OTP code for a specific user.
 * This is separate from validateVerificationToken because OTPs are not unique in the table.
 */
function validateLoginOTP($otp_code, $user_id) {
    $pdo = getDBConnection();
    
    try {
        // Find the most recent, valid OTP for this user
        $stmt = $pdo->prepare("SELECT * FROM verification_tokens
                                WHERE token = ? 
                                  AND user_id = ? 
                                  AND type = 'login_otp' 
                                  AND used = 0 
                                  AND expires_at > NOW()
                                ORDER BY id DESC 
                                LIMIT 1");
        $stmt->execute([$otp_code, $user_id]);
        
        $token_data = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($token_data) {
            // Mark token as used
            $stmt = $pdo->prepare("UPDATE verification_tokens SET used = 1, used_at = NOW() WHERE id = ?");
            $stmt->execute([$token_data['id']]);
            
            // Return all token data (including user_id for cross-check)
            return $token_data;
        }
        
        return false;
    } catch (PDOException $e) {
        error_log("OTP validation error: " . $e->getMessage());
        return false;
    }
}
// --- END OF NEW FUNCTION ---

// Email sending function with PHPMailer support
function sendEmail($to, $subject, $body) {
    error_log("Attempting to send email to: $to");
    error_log("Subject: $subject");
    
    try {
        // Check if PHPMailer class was successfully loaded
        if (class_exists(PHPMailer::class)) {
            return sendEmailWithPHPMailer($to, $subject, $body);
        } else {
            // FIX 2: Do NOT fall back to mail().
            // If PHPMailer isn't found, it's a fatal setup error.
            error_log("FATAL: PHPMailer class not found. Email cannot be sent.");
            return false;
        }
    } catch (Exception $e) {
        error_log("Email sending failed: " . $e->getMessage());
        // For development, return FALSE to stop registration if email fails.
        // This is so you can see the error on the registration page.
        // Change back to 'true' in production if you want to allow registration
        // even if the verification email fails.
        return false;
    }
}

// PHPMailer implementation
function sendEmailWithPHPMailer($to, $subject, $body) {
    $mail = new PHPMailer(true); // Enable exceptions
    
    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host = SMTP_HOST;
        $mail->SMTPAuth = true;
        $mail->Username = SMTP_USERNAME;
        $mail->Password = SMTP_PASSWORD;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Use class constant
        $mail->Port = SMTP_PORT;
        
        // Recipients
        $mail->setFrom(SMTP_FROM_EMAIL, SMTP_FROM_NAME);
        $mail->addAddress($to);
        $mail->addReplyTo(SMTP_FROM_EMAIL, SMTP_FROM_NAME);
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $body;
        $mail->AltBody = strip_tags($body);
        
        $mail->send();
        error_log("Email sent successfully via PHPMailer to: $to");
        return true;
    } catch (PHPMailerException $e) {
        error_log("PHPMailer Error: {$mail->ErrorInfo}");
        // Do not fall back to basic mail, as it's unreliable.
        // Just return false so the application knows the email failed.
        return false;
    }
}

// Basic mail() function fallback
function sendEmailWithMail($to, $subject, $body) {
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: " . SMTP_FROM_NAME . " <" . SMTP_FROM_EMAIL . ">" . "\r\n";
    $headers .= "Reply-To: " . SMTP_FROM_EMAIL . "\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();
    
    $success = mail($to, $subject, $body, $headers);
    
    if ($success) {
        error_log("Email sent successfully via mail() to: $to");
    } else {
        error_log("Email failed to send via mail() to: $to");
    }
    
    return $success;
}

// User verification functions
function verifyUserEmail($user_id) {
    $pdo = getDBConnection();
    
    try {
        // Check if email_verified column exists, add if not
        $column_check = $pdo->query("SHOW COLUMNS FROM users LIKE 'email_verified'");
        if ($column_check->rowCount() == 0) {
            $pdo->exec("ALTER TABLE users ADD COLUMN email_verified TINYINT DEFAULT 0");
        }
        
        $stmt = $pdo->prepare("UPDATE users SET email_verified = 1, verified_at = NOW() WHERE id = ?");
        return $stmt->execute([$user_id]);
    } catch (PDOException $e) {
        error_log("Email verification error: " . $e->getMessage());
        return false;
    }
}

function isEmailVerified($user_id) {
    $pdo = getDBConnection();
    
    try {
        $stmt = $pdo->prepare("SELECT email_verified FROM users WHERE id = ?");
        $stmt->execute([$user_id]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        return $user && $user['email_verified'] == 1;
    } catch (PDOException $e) {
        error_log("Email verification check error: " . $e->getMessage());
        return false;
    }
}

// Function to send login OTP
function sendLoginOTP($user_id, $email, $name) {
    // Generate OTP (6-digit code)
    $otp_code = str_pad(mt_rand(1, 999999), 6, '0', STR_PAD_LEFT);
    
    // Store OTP as verification token
    $pdo = getDBConnection();
    
    try {
        $stmt = $pdo->prepare("INSERT INTO verification_tokens (user_id, token, type, expires_at) VALUES (?, ?, ?, ?)");
        $expires_at = date('Y-m-d H:i:s', strtotime('+10 minutes'));
        $stmt->execute([$user_id, $otp_code, 'login_otp', $expires_at]);
        
        // Send OTP email
        $subject = "Your Login OTP - Airwaves credit union";
        $otp_body = "
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: #1a472a; color: white; padding: 20px; text-align: center; }
                .content { background: #f9f9f9; padding: 20px; }
                .otp-code { 
                    font-size: 32px; 
                    font-weight: bold; 
                    text-align: center; 
                    letter-spacing: 8px; 
                    color: #1a472a; 
                    margin: 20px 0;
                    padding: 15px;
                    background: #f0f0f0;
                    border-radius: 5px;
                }
                .footer { text-align: center; margin-top: 20px; font-size: 12px; color: #666; }
            </style>
        </head>
        <body>
            <div class='container'>
                <div class='header'>
                    <h1>Airwaves Credit Union</h1>
                </div>
                <div class='content'>
                    <h2>Your Login Verification Code</h2>
                    <p>Hello $name,</p>
                    <p>You requested an OTP to login to your Airwaves Credit union  account. Use the code below to complete your login:</p>
                    <div class='otp-code'>$otp_code</div>
                    <p>This OTP code will expire in 10 minutes.</p>
                    <p>If you didn't request this OTP, please ignore this email and secure your account.</p>
                </div>
                <div class='footer'>
                    <p>&copy; 2025 AIRWAVES Credits. All rights reserved.</p>
                </div>
            </div>
        </body>
        </html>";
        
        return sendEmail($email, $subject, $otp_body);
    } catch (PDOException $e) {
        error_log("OTP storage error: " . $e->getMessage());
        return false;
    }
}

// Token cleanup function
function cleanupExpiredTokens() {
    $pdo = getDBConnection();
    
    try {
        $stmt = $pdo->prepare("DELETE FROM verification_tokens WHERE expires_at < NOW() OR used = 1");
        return $stmt->execute();
    } catch (PDOException $e) {
        error_log("Token cleanup error: " . $e->getMessage());
        return false;
    }
}

// Auto-create necessary database tables and columns
function initializeDatabase() {
    try {
        $pdo = getDBConnection();
        
        // Create verification_tokens table if it doesn't exist
        // --- FIX: Removed UNIQUE constraint from 'token' and added a non-unique INDEX ---
        $pdo->exec("CREATE TABLE IF NOT EXISTS verification_tokens (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            token VARCHAR(64) NOT NULL,
            type VARCHAR(50) NOT NULL,
            used TINYINT DEFAULT 0,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            used_at TIMESTAMP NULL,
            expires_at TIMESTAMP NOT NULL,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
            INDEX (token)
        )");

        // --- NEW FIX: Attempt to drop the old unique constraint if it exists ---
        // This is necessary to allow non-unique OTP codes.
        try {
            // First, check if the unique index exists (MySQL-specific)
            // The default unique key name is often the column name.
            $index_check = $pdo->query("SHOW INDEX FROM verification_tokens WHERE Key_name = 'token' AND Non_unique = 0");
            if ($index_check && $index_check->rowCount() > 0) {
                // If the unique index 'token' exists, drop it
                $pdo->exec("ALTER TABLE verification_tokens DROP INDEX token");
                // Add a non-unique index back for performance
                $pdo->exec("ALTER TABLE verification_tokens ADD INDEX (token)");
                error_log("FIX: Dropped unique index and added non-unique index on 'token' column.");
            }
        } catch (PDOException $e) {
            // Ignore errors (e.g., index doesn't exist, or user permissions)
            error_log("Notice: Could not modify 'token' index (it may be correct already): " . $e->getMessage());
        }
        // --- END OF NEW FIX ---
        
        // Add missing columns to users table
        $columns_to_add = [
            'email_verified' => "ALTER TABLE users ADD COLUMN IF NOT EXISTS email_verified TINYINT DEFAULT 0",
            'verification_sent_at' => "ALTER TABLE users ADD COLUMN IF NOT EXISTS verification_sent_at TIMESTAMP NULL",
            'verified_at' => "ALTER TABLE users ADD COLUMN IF NOT EXISTS verified_at TIMESTAMP NULL", 
            'is_active' => "ALTER TABLE users ADD COLUMN IF NOT EXISTS is_active TINYINT DEFAULT 1",
            'last_login' => "ALTER TABLE users ADD COLUMN IF NOT EXISTS last_login TIMESTAMP NULL"
        ];
        
        foreach ($columns_to_add as $column => $sql) {
            try {
                $pdo->exec($sql);
            } catch (PDOException $e) {
                // Ignore errors if column already exists
                if (strpos($e->getMessage(), 'duplicate') === false) {
                    error_log("Database initialization error: " . $e->getMessage());
                }
            }
        }
        
        error_log("Database initialization completed successfully");
        
    } catch (PDOException $e) {
        error_log("Database initialization failed: " . $e->getMessage());
    }
}

// Initialize database on first load
initializeDatabase();

// Debug function
function debugLog($message) {
    if (DEBUG_MODE) {
        error_log("DEBUG: " . $message);
    }
}
?>